/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  menu.c
//  Functions for the menu
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#include "main.h"
#include "menu.h"




// This function shows several menus and parameters on the display.

// variables to show a number in the format XX.X or XXX (first, second, third digit)
void print_parameter(unsigned int parameter, unsigned int position, unsigned int line)
{
	unsigned int first_digit, second_digit, third_digit;
	unsigned int i;
	first_digit = parameter / 100;
	i = parameter % 100;
	second_digit = i / 10;
	third_digit = i % 10;

	lcd_gotoxy(position,line);
	if(first_digit > 0) lcd_puti(first_digit);
	else lcd_puts(" ");
	lcd_puti(second_digit); lcd_puts(".");
	lcd_puti(third_digit);
}

// variables to show a number in the format XX.X or XXX (first, second, third digit)
void print_regulation_parameter(unsigned int parameter, unsigned int position, unsigned int line)
{
	unsigned int first_digit, second_digit, third_digit;
	unsigned int i;
	parameter = parameter / 10;
	first_digit = parameter / 100;
	i = parameter % 100;
	second_digit = i / 10;
	third_digit = i % 10;

	lcd_gotoxy(position,line);
	if(first_digit > 0) lcd_puti(first_digit);
	else lcd_puts(" ");
	lcd_puti(second_digit); lcd_puts(".");
	lcd_puti(third_digit);
}

void delete_second_raw (void)
{
	lcd_gotoxy(0,1);	lcd_puts("                ");
}

void show_info(unsigned int menu_selection)
{
	unsigned int temperature;

	switch(menu_selection)
	{
		case 0: lcd_gotoxy(0,0); lcd_puts("V=    V,I=     A");
				lcd_gotoxy(0,1); lcd_puts("SET READ ALM    ");
				print_regulation_parameter(voltage_output,2,0);	// print the output voltage
				print_regulation_parameter(current_output,10,0);	// print the output current
				lcd_gotoxy(13,1);
				if(charge_enabled)	lcd_puts("ON ");
				else lcd_puts("OFF");

				break;

// Master/Slave configuration,	master_slave = 10 -> Only the master is present ("stand alone system");
// 								master_slave < 10 means: this charger is the master and there are (10 - master_slave) slaves (example: master_slave = 8 means: one master + 2 slaves);
// 								master_slaves > 10  means: this charger is a slave and its number is (master_slave - 10);
		case 10:
			lcd_gotoxy(0,0); 		lcd_puts("M/S Config.:    ");
				lcd_gotoxy(0,1);
				if(master_slave == 10)	lcd_puts("  STAND ALONE   ");
				if(master_slave < 10)
				{
					lcd_puts("  MASTER+ SLAVES");
					lcd_gotoxy(9,1); lcd_puti(10-master_slave);
				}
				if(master_slave > 10)
				{
					lcd_puts("  SLAVE #       ");
					lcd_gotoxy(9,1); lcd_puti(master_slave-10);
				}
		break;

		case 11:
			lcd_gotoxy(0,0); 		lcd_puts("Type of battery:");
				lcd_gotoxy(0,1);
				if(battery_type)	lcd_puts("  GEL           ");
				else 				lcd_puts("  Lead Acid     ");
		break;

		case 12:
			lcd_gotoxy(0,0); 		lcd_puts("Trickle level:  ");
				delete_second_raw ();
				print_parameter(trickle_voltage,2,1); lcd_puts("V");	// print the trickle charge voltage level
		break;

		case 13:
			lcd_gotoxy(0,0); 		lcd_puts("Float level:    ");
				delete_second_raw ();
				print_parameter(float_voltage,2,1);	lcd_puts("V");// print the float charge voltage level
		break;

		case 14:
			lcd_gotoxy(0,0); 		lcd_puts("Minimum level:  ");
				delete_second_raw ();
				print_parameter(minimum_voltage,2,1); lcd_puts("V");	// print the minimum voltage level
		break;

		case 15:
			lcd_gotoxy(0,0); 		lcd_puts("Charge Current: ");
				delete_second_raw ();
				lcd_gotoxy(2,1); lcd_puti(current_limit);	lcd_puts("A");// print the current limit
		break;

		case 16:
			lcd_gotoxy(0,0); 		lcd_puts("Power Limit:    ");
				delete_second_raw ();
				lcd_gotoxy(2,1); lcd_puti(power_limit);	lcd_puts("0W");// print the maximum allowed output power
		break;

		case 17:
			lcd_gotoxy(0,0); 		lcd_puts("Min-curr. trick:");
				delete_second_raw ();
				lcd_gotoxy(2,1); lcd_puti(minimum_current_trickle); lcd_puts("A"); // print the minimum current to enter trickle charge
		break;

		case 18:
			lcd_gotoxy(0,0); 		lcd_puts("Mains UVLO:     ");
				delete_second_raw ();
				lcd_gotoxy(2,1); lcd_puti(mains_uvlo); lcd_puts("V");// print the input AC minimum voltage
		break;

		case 19:
			lcd_gotoxy(0,0); 		lcd_puts("Mains OVV:      ");
				delete_second_raw ();
				lcd_gotoxy(2,1); lcd_puti(mains_ovv); lcd_puts("V");	// print the input AC maximum voltage
		break;

		case 20:
			lcd_gotoxy(0,0); 		lcd_puts("Temperat. coeff:");
				delete_second_raw ();
				lcd_gotoxy(2,1); lcd_puti(temperature_coefficient);	lcd_puts(" %/100C");// print the compensation of Vout as function of battery temperature
		break;

		case 21:
			lcd_gotoxy(0,0); 		lcd_puts("Overtemperature:");
				delete_second_raw ();
				lcd_gotoxy(2,1); lcd_puti(overtemperature_protection);	lcd_puts("C");// print the compensation of Vout as function of battery temperature
		break;

		case 22:
			lcd_gotoxy(0,0); 		lcd_puts("Backlight:      ");
			lcd_gotoxy(0,1);
			if(backlight==0)		lcd_puts("  Always OFF    ");
			else if (backlight==1)	lcd_puts("  Always ON     ");
			else if (backlight==2)	lcd_puts("  Timer         ");
		break;

		case 23:
			lcd_gotoxy(0,0); 		lcd_puts(" Configuration  ");
			lcd_gotoxy(0,1);		lcd_puts("    SAVED!      ");
		break;

		case 30: 	lcd_gotoxy(0,0); lcd_puts("Vac(rms):      V");
					lcd_gotoxy(0,1); lcd_puts("Temperature:   C");
					lcd_gotoxy(11,0); lcd_puti(voltage_ac);				// print the Vac input voltage
					lcd_gotoxy(12,1);
					if(temperature_plus_50 >= 50)
					{
						temperature = temperature_plus_50 - 50;
						lcd_puti(temperature);	// print the temperature
					}
					else
					{
						temperature = 50 - temperature_plus_50;
						lcd_puts("-"); lcd_puti(temperature);			// print the temperature below zero
					}

		break;

		case 31: 	lcd_gotoxy(0,0); lcd_puts("Status:         ");
					lcd_gotoxy(0,1); lcd_puts("Charge level:  %");
					lcd_gotoxy(8,0); lcd_puti(status_charger);
//					if(status_charger==0) 								lcd_puts("OFF");
//					else if ((status_charger>0)&&(status_charger<5))	lcd_puts("Start-up ");
//					else if (status_charger==5)							lcd_puts("Charging");
		break;

		case 32: 	lcd_gotoxy(0,0); lcd_puts("Fan speed (rpm) ");
					delete_second_raw ();
					lcd_gotoxy(0,1); lcd_puti(Fan_speed);
//					lcd_gotoxy(0,1); lcd_puti(input_current);
		break;

		case 40: 	lcd_gotoxy(0,0); lcd_puts("   No Alarms    ");
					lcd_gotoxy(0,1); lcd_puts("  No Warnings   ");
		break;

		case 41: 	if((alarm & BIT0)==BIT0) lcd_gotoxy(0,1); lcd_puts("Vin too LOW     ");
		break;

		case 42: 	lcd_gotoxy(0,1); lcd_puts("Vin too HIGH    ");
		break;

		case 43: 	lcd_gotoxy(0,1); lcd_puts("Vout Overvoltage");
		break;

		case 44: 	lcd_gotoxy(0,1); lcd_puts("Output Shorted  ");
		break;

		case 45: 	lcd_gotoxy(0,1); lcd_puts("Overtemperature ");
		break;

		case 46: 	lcd_gotoxy(0,1); lcd_puts("Fan failure     ");
		break;

		case 47: 	lcd_gotoxy(0,1); lcd_puts("DC/DC failure   ");
		break;

		case 48: 	lcd_gotoxy(0,1); lcd_puts("Output I-limit  ");
		break;

		case 49: 	lcd_gotoxy(0,1); lcd_puts("Power Limit     ");
		break;

		case 50: 	lcd_gotoxy(0,1); lcd_puts("Input I-limit   ");
		break;

		case 51: 	lcd_gotoxy(0,1); lcd_puts("Low V-Battery   ");
		break;

	}	// switch(menu_selection)

	if((menu_selection == 40) && (alarm > 0))
	{
		key_minus_short = 1;
		key_esc_short = 1;
	}

	if ((menu_selection > 40) && (menu_selection < 48) && (alarm > 0))
	{
		lcd_gotoxy(0,0);
		lcd_puts("Alarm: (ENT=RST)");
	}

	if ((menu_selection > 47) && (menu_selection < 52) && (warning > 0))
	{
		lcd_gotoxy(0,0);
		lcd_puts("Warning:        ");
	}

	if(menu_modify && (menu_selection > 0))
	{
		lcd_gotoxy(0,1);
		lcd_puts("->");
	}

}



// This function checks if all parameters are within range.
// If a fault is present, the corresponding bit of the alarm word will be set to 1.

// "alarm" is a global variable to indicate that there is an alarm;
// alarm = 0 -> no alarm
// bit0 => Mains UVLO
// bit1 => Mains OVV
// bit2 => Output overvoltage
// bit3 => Output Shorted
// bit4 => Overtemperature 1
// bit5 => Overtemperature 2		-> not used
// bit6 => Fan Failure
// bit7 => DC/DC Failure

// "warning" is a global variable to indicate that there is a warning;
// warning=0 -> no warning
// bit0 => Output Current Limit
// bit1 => Output Power Limit
// bit2 => Input Current Limit
// bit3 => Low Battery Voltage

void check_status(void)
{
	static signed int error_voltage_output_high=0;
	static signed int error_voltage_mains_low=0;
	static signed int error_voltage_mains_high=0;
	static signed int error_fan_fail=0;

	static signed int warning_current_output_high=0;
	static signed int warning_output_power_high=0;
	static signed int warning_input_current_high=0;

	// Check if all parameters are within range; the routine is called every 10 milliseconds

	// If one of the parameter below is n times in a row out
	// of range, the corresponding bit alarm is set.
	
	if((voltage_ac < mains_uvlo)&&(test==0))
	{
		if(error_voltage_mains_low < 200)	error_voltage_mains_low = error_voltage_mains_low + 10;		//Quick going into Mains UVLO
		else								alarm = alarm | 0x0001;										// Mains Undervoltage lockout (Mains UVLO)
	}
	else
	{

		if((error_voltage_mains_low > 0)&&(test==0))		error_voltage_mains_low--;									// Slow exiting from UVLO (slow re-enabling the converter),  (200 x 10msec = 2 sec)
		else								alarm = alarm & 0xFFFE;										// No mains UVLO
	}


	if((voltage_ac > mains_ovv)&&(test==0))
	{
		if(error_voltage_mains_high < 200)	error_voltage_mains_high = error_voltage_mains_high + 10;	//Quick going into Mains OVV
		else								alarm = alarm | 0x0002;										// Mains Over voltage (Mains OVV)
	}
	else
	{

		if((error_voltage_mains_high > 0)&&(test==0))	error_voltage_mains_high--;									// Slow exiting from OVV (slow re-enabling the converter),  (200 x 10msec = 2 sec)
		else								alarm = alarm & 0xFFFD;										// No mains OVV
	}
	

	if((voltage_output > (float_voltage*10+50))&&(test==0))
	{
		if(error_voltage_output_high < 200)	error_voltage_output_high++;								//Slowly going into output overvoltage protection (open terminals)
		else
		{
			alarm = alarm | 0x0004;										// Mains Over voltage (Mains OVV)
			error_voltage_output_high = 0;								//Not resettable automatically: it must be done from the keyboard
		}
	}

	if((temperature_plus_50 > (overtemperature_protection + 50))&&(test==0))			alarm = alarm | 0x0010;			// Goes quickly into overtemperature due to its slow increase / decrease
	if((temperature_plus_50 < (overtemperature_protection + 30))&&(test==0))			alarm = alarm & 0xFFEF;			// Hysteresis = 20 degrees
		
	if (current_output >= (current_limit * 95))
	{
		if(warning_current_output_high < 200) warning_current_output_high++;	// Current limit for more than 2 seconds
		else								warning = warning | 0x0001;
	}
	else
	{
		if(warning_current_output_high > 0)	warning_current_output_high--;
		else								warning = warning & 0xFFFE;
	}

	output_power = current_output;
	output_power = output_power * voltage_output;
	input_current = output_power;
	input_current = input_current / voltage_ac;					// Input current calculated as Pout/(Vac*efficiency), where the efficiency is 93%
	input_current = input_current / 93;							// input current = 500 for current = 5A
	output_power = output_power / 10000;						// Output power in Watt
	if (output_power > (power_limit*10))
	{
		if(warning_output_power_high < 200) warning_output_power_high++;	// Power limit for more than 2 seconds
		else								warning = warning | 0x0002;
	}
	else
	{
		if(warning_output_power_high > 0)	warning_output_power_high--;
		else								warning = warning & 0xFFFD;
	}

	if (((current_output > 1000) && (Fan_speed == 800))&&(test==0))
	{
		if(error_fan_fail < 200) error_fan_fail++;							// Fan stopped for more than 2 seconds
		else								alarm = alarm | 0x0020;
	}
	else
	{
		if(error_fan_fail > 0)	error_fan_fail--;
		else								alarm = alarm & 0xFFDF;
	}

	if (input_current > 1000)									// Input current limit @ 10A
	{
		if(warning_input_current_high < 200) warning_input_current_high++;	// Input current limit for more than 2 seconds
		else								warning = warning | 0x0004;
	}
	else
	{
		if(warning_input_current_high > 0)	warning_input_current_high--;
		else								warning = warning & 0xFFFB;
	}

}
